/*** 1.   ũƮ ***/

CREATE TABLE TB_PartitionTable 
	(ID INT, ProductName VARCHAR(64), ModifiedDate date, Time time)

DECLARE @i INT, @date varchar(16), @time varchar(16)
SET @i = 1
SET @date = NULL
SET @time = '10:00:00'
WHILE (@i < 1000)
	BEGIN
		SET @date = '2020-01-10'
		INSERT INTO TB_PartitionTable VALUES (@i, NEWID(), @date, @time)
		SET @date = '2020-02-10'
		INSERT INTO TB_PartitionTable VALUES (@i+1, NEWID(), @date, @time)
		SET @date = '2020-03-10'
		INSERT INTO TB_PartitionTable VALUES (@i+2, NEWID(), @date, @time)
		SET @date = '2020-04-10'
		INSERT INTO TB_PartitionTable VALUES (@i+3, NEWID(), @date, @time)
		SET @date = '2020-05-10'
		INSERT INTO TB_PartitionTable VALUES (@i+4, NEWID(), @date, @time)
		SET @date = '2020-06-10'
		INSERT INTO TB_PartitionTable VALUES (@i+5, NEWID(), @date, @time)
		SET @date = '2020-07-10'
		INSERT INTO TB_PartitionTable VALUES (@i+6, NEWID(), @date, @time)
		SET @date = '2020-08-10'
		INSERT INTO TB_PartitionTable VALUES (@i+7, NEWID(), @date, @time)
		SET @i = @i + 8
	END
WHILE (@i < 149800)
	BEGIN
		SET @date = '2020-09-03'
		SET @time = '02:00:00'
		INSERT INTO TB_PartitionTable VALUES (@i, NEWID(), @date, @time)
		SET @i = @i + 1
	END
WHILE (@i < 150000)
	BEGIN
		SET @date = '2020-09-10'
		SET @time = '10:00:00'
		INSERT INTO TB_PartitionTable VALUES (@i, NEWID(), @date, @time)
		SET @i = @i + 1
	END
CREATE CLUSTERED INDEX CIDX_PartitionTable ON TB_PartitionTable(ModifiedDate, Time)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT ProductName
FROM TB_PartitionTable
WHERE ModifiedDate BETWEEN '2020-09-01' AND '2020-09-30'
AND Time BETWEEN '09:00:00' AND '18:00:00'
GO


/*** 6. [TO-BE]   ***/

--̺  
DROP INDEX CIDX_PartitionTable ON TB_PartitionTable

CREATE PARTITION FUNCTION Partition_FN_TB_PT (date) 
AS RANGE LEFT FOR VALUES (N'2020-01-01', N'2020-02-01', N'2020-03-01'
			, N'2020-04-01',	N'2020-05-01', N'2020-06-01'
			, N'2020-07-01', N'2020-08-01', N'2020-09-01', N'2020-10-01')

CREATE PARTITION SCHEME Partition_Scheme_TB_PT
AS PARTITION Partition_FN_TB_PT TO ([PRIMARY], [PRIMARY], [PRIMARY], [PRIMARY]
				    , [PRIMARY], [PRIMARY], [PRIMARY], [PRIMARY]
				    , [PRIMARY], [PRIMARY], [PRIMARY])

CREATE CLUSTERED INDEX CIDX_PT_Scheme ON dbo.TB_PartitionTable
(ModifiedDate) ON Partition_Scheme_TB_PT(ModifiedDate)
GO 

--ε  
CREATE INDEX NIDX01_PartitionTable ON TB_PartitionTable(Time) INCLUDE (ProductName)
GO

--SQL  
SELECT ProductName
FROM TB_PartitionTable
WHERE ModifiedDate BETWEEN '2020-09-01' AND '2020-09-30'
AND Time BETWEEN '09:00:00' AND '18:00:00'
GO
